/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.SocketProxyAgent;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.util.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;

public class JadeBridge {
    public static final String DEFAULT_AGENT_PROXY_HOST = "localhost";
    public static final int DEFAULT_AGENT_PROXY_PORT = 6789;
    private static final Logger logger = Logger.getMyLogger((class$jade$tools$SocketProxyAgent$JadeBridge == null ? (class$jade$tools$SocketProxyAgent$JadeBridge = JadeBridge.class$("jade.tools.SocketProxyAgent.JadeBridge")) : class$jade$tools$SocketProxyAgent$JadeBridge).getName());
    private String host;
    private int port;
    static /* synthetic */ Class class$jade$tools$SocketProxyAgent$JadeBridge;

    public JadeBridge() {
        this(DEFAULT_AGENT_PROXY_HOST, 6789);
    }

    public JadeBridge(String aHost, int aPort) {
        this.host = aHost;
        this.port = aPort;
        logger.log(Logger.CONFIG, "bridge constructed for " + this.host + ":" + this.port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String sendMessage(String aMsg) {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "msg to send:" + aMsg);
        }
        String response = null;
        try {
            response = this.sendACL(aMsg).toString();
        }
        catch (Exception e) {
            response = "Exception when sending ACL:" + e;
        }
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "response:" + response);
        }
        return response;
    }

    public ACLMessage sendMessage(ACLMessage aMsg) {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "msg to send:" + aMsg);
        }
        ACLMessage response = null;
        try {
            response = this.sendACL(aMsg.toString());
        }
        catch (Exception e) {
            response = new ACLMessage(6);
            response.setContent("Exception when sending ACL:" + e);
        }
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "response:" + response);
        }
        return response;
    }

    public ACLMessage sendACL(String aMsg) throws IOException, UnknownHostException, SocketException {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "msg to send:" + aMsg);
        }
        int ONE_SEC_AS_MS = 1000;
        int timeout = 60000;
        Socket socket = new Socket(this.host, this.port);
        socket.setSoTimeout(timeout);
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "created socket to host \"" + this.host + "\", port " + this.port + ", timeout " + timeout + "ms");
        }
        ACLMessage response = null;
        PrintStream out = new PrintStream(socket.getOutputStream());
        DataInputStream in = new DataInputStream(socket.getInputStream());
        out.println(aMsg);
        out.flush();
        Date startTime = new Date();
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "trying to get response...");
        }
        try {
            ACLParser parser = new ACLParser(in);
            response = parser.Message();
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "response:" + response);
            }
        }
        catch (Throwable any) {
            Date endTime;
            long millisecs;
            if (logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "caught " + any + " trying to get response", any);
            }
            if ((millisecs = (endTime = new Date()).getTime() - startTime.getTime()) > (long)(timeout * 95 / 100)) {
                response = new ACLMessage(6);
                response.setContent("( \"Timeout waiting for response from SocketProxy.\" )");
            }
            response = new ACLMessage(6);
            response.setContent("( \"JadeBridge error in parsing ACL response from SocketProxy:" + any + "\" )");
        }
        socket.close();
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "returning...");
        }
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

